/******************************************************************************/
#include "stdafx.h"
/******************************************************************************/
Mshb mshb; // mesh base (contains vertexes, edges, triangles, quads)
/******************************************************************************/
void InitPre()
{
   App.name="Mesh";
   App.flag=APP_MS_EXCLUSIVE; // mouse exclusive mode to hide cursor, and APP_NO_FX removed since we'll be using vertex lit Mshb rendering
   PakAdd("../data/engine.pak");
}
/******************************************************************************/
Bool Init()
{
   Cam.dist=4;
   mshb.create(Torus(1,0.3),VTX_NRM); // create Mshb from torus, and automatically create vertex normals in order to lit the mshb properly
   return true;
}
/******************************************************************************/
void Shut()
{
}
/******************************************************************************/
Bool Main()
{
   if(Kb.bp(KB_ESC))return false;
   CamHandle(0.1,10,CAMH_ROT|CAMH_ZOOM);
   return true;
}
/******************************************************************************/
void Draw()
{
   D.clear(TURQ);
   LightDir(1,Vec(0,0,1)).set(); // set directional light in (0,0,1) direction before rendering to achieve lighting (NOTE: only directional light is supported in simple rendering mode)

   if(Ms.b(0)) // when left mouse button on
   {
      Torus(1,0.3).draw(WHITE,true); // draw flat colored torus through Torus shape
   }else
   {
      mshb.draw(NULL); // render through Mshb with default material (it will be shaded properly because it has vertex normals)
   }
}
/******************************************************************************/
